using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using System.ComponentModel;
using System.Drawing.Design;
using System.Web.UI.Design;
using System.IO;

public partial class BC_Uploader : System.Web.UI.UserControl
{
    private string _uploadPath;    

    public string UploadPath
    {
        get { return _uploadPath; }
        set { _uploadPath = value; }
    }

    protected void Page_Load(object sender, EventArgs e)
    {    
    }
    protected override void OnPreRender(EventArgs e)
    {
        if (!Page.ClientScript.IsClientScriptIncludeRegistered("bc_header_script"))
            Page.ClientScript.RegisterClientScriptInclude("bc_header_script", "scripts/utils.js");

        string init_script = string.Format(@"bc_load('{0}', '{1}');", inputField.ClientID, list_files.ClientID);
        Page.ClientScript.RegisterClientScriptBlock(this.GetType(), this.ClientID, init_script, true);
        base.OnPreRender(e);
    }
    
    protected void cmdUpload_Click(object sender, EventArgs e)
    {
        if (Directory.Exists(_uploadPath))
        {

            HttpFileCollection files = HttpContext.Current.Request.Files;
            for (int i = 0; i < files.Count; i++)
            {
                HttpPostedFile file = files[i];
                
                if (file.ContentLength == 0)
                    continue;
                try
                {
                    //upload.SaveAs(Path.Combine(_uploadPath, file.FileName));
                    Response.Write(file.FileName);
                }
                catch
                {
                    // Manejar el error
                }                
            }
        }
    }
}
