<?php

/*
Plugin Name: WP-FullText-Search
Version: 1.0-beta
Plugin URI: http://www.buayacorp.com/
Author: Alexander Concha
Description: Adds Full-Text Search to your WordPress Blog.
Author URI: http://www.buayacorp.com/
*/
if ( !function_exists('add_action') ) die;

load_plugin_textdomain('wp-fulltext-search',$path = 'wp-content/plugins/wp-fulltext-search');

class WP_FullTextSearch {
	var $wpQuery;
	var $search_terms;
	var $search_mode;
	var $options = array('enabled' => false, 'search_mode' => 'wp');
	
	function GetPostsFilter($wpQuery) {
		global $wpdb, $wp_version;
		
		$this->wpQuery = &$wpQuery;
		$this->search_terms = trim(stripslashes($wpQuery->get('s')));
		
		if ( strlen($this->search_terms) < 4 ) 
			return false;
		$this->options = get_option('wp-fulltext-search');
		
		if ( empty($this->options['enabled']) || 'wp' == $this->options['search_mode'] )
			return false;
		
		switch ($this->options['search_mode']) {
			case 'boolean':
				$this->search_mode = 'IN BOOLEAN MODE';
				break;
			case 'expansion':
				$this->search_mode = 'WITH QUERY EXPANSION';
		}
		
		$this->search_terms = $wpdb->escape($this->search_terms);
		$wpQuery->query_vars['s'] = '';
		
		if ( preg_match('/^2\.0.*$/', $wp_version) ) { // 2.0.x compatibility
			add_filter('posts_request', array(&$this, 'RequestFilter'));
		} else {
			add_filter('posts_fields', array(&$this, 'FieldFilter'));
		}
		add_filter('posts_where', array(&$this, 'WhereFilter'));
		add_filter('posts_orderby', array(&$this, 'OrderByFilter'));		
	}	
	function RequestFilter($request) {		
		return preg_replace('/^\s*SELECT (.*?) FROM/', "SELECT \\1, MATCH (post_title, post_content) 
						AGAINST ('$this->search_terms' $this->search_mode) as hits FROM", $request);
	}
	function FieldFilter($fields) {
		return $fields . ", MATCH (post_title, post_content) 
						AGAINST ('$this->search_terms' $this->search_mode) as hits";
	}
	function WhereFilter($where) {
		$this->wpQuery->query_vars['s'] = $this->search_terms;
		return $where . " AND ( MATCH (post_title, post_content) AGAINST ('$this->search_terms' $this->search_mode) )";
	}
	function OrderByFilter($orderby) {
		return 'hits DESC' . (empty($orderby) ? '' : ", $orderby");
	}
	
	function AdminMenu() {
		add_submenu_page('plugins.php', __('Search Options', 'wp-fulltext-search'), __('Search', 'wp-fulltext-search'), 10, __FILE__, array(&$this, 'AdminOptions'));
	}
	function AdminOptions() {
		global $wpdb;
		
		$enabled = $this->CreateIndex();
		if ( 'POST' == $_SERVER['REQUEST_METHOD'] ) {
			check_admin_referer('wp-fulltext-search');
			
			if ( isset($_POST['create-index']) && $this->CreateIndex(false) ) {
				$this->options['enabled'] = true;
			} elseif ( isset($_POST['drop-index']) ) {
				$this->DropIndex();
				$this->options['enabled'] = false;
			} else {
				$search_mode = 'wp';
				if ( !empty($_POST['search_mode']) && in_array($_POST['search_mode'], array('none', 'boolean', 'expansion')) )
					$search_mode = $_POST['search_mode'];
				$this->options['search_mode'] = $search_mode;
			}
			$enabled = $this->options['enabled'];
			update_option('wp-fulltext-search', $this->options);
		}
		$this->options = get_option('wp-fulltext-search');
		$this->options['enabled'] = $enabled; // Makes sense?
?>
	<div class="wrap">
	
	<h2><?php _e('Search Options', 'wp-fulltext-search'); ?></h2>
	
	<form action="" method="post">
	<?php wp_nonce_field('wp-fulltext-search') ?>
	
	<?php if ( empty($this->options['enabled']) ) : ?>
	<div id="message" class="updated fade">
		<p><?php echo sprintf(__('There is no FULLTEXT index on <code>%sposts</code> table for <code>post_title</code> and <code>post_content</code> fields. Would you like to add one?', 'wp-fulltext-search'), $wpdb->prefix) ?></p>
	</div>
	<p class="submit" style="text-align: center;"><input type="submit" name="create-index" value="<?php _e('Create Index &raquo;', 'wp-fulltext-search') ?>" /><br />
	<strong style="color:#f00;"><?php _e('Please, backup your data before you proceed', 'wp-fulltext-search') ?>.</strong></p>
	<?php else : ?>
	<p class="submit"><input type="submit" name="Submit" value="<?php _e('Update Options &raquo;') ?>" /></p>
	<table class="optiontable">
		<tr>
			<th scope="row"><?php _e('Search Method', 'wp-fulltext-search') ?>:</th>
			<td>
				<input type="radio" name="search_mode" id="sm_wp" value="wp" <?php checked('wp', $this->options['search_mode']);?>/>
				<label for="sm_wp"><?php _e('WordPress Search.', 'wp-fulltext-search') ?></label>
				<br/>

				<input type="radio" name="search_mode" id="sm_none" value="none" <?php checked('none', $this->options['search_mode']);?>/>
				<label for="sm_none"><?php _e('Full-Text Search without modifiers', 'wp-fulltext-search') ?> (<a href="http://dev.mysql.com/doc/refman/5.0/en/fulltext-search.html">#</a>).</label>
				<br/>
							
				<input type="radio" name="search_mode" id="sm_boolean" value="boolean" <?php checked('boolean', $this->options['search_mode']);?>/>
				<label for="sm_boolean"><?php _e('Boolean Full-Text Search', 'wp-fulltext-search') ?> (<a href="http://dev.mysql.com/doc/refman/5.0/en/fulltext-boolean.html">#</a>).</label>
				<br/>
				
				<input type="radio" name="search_mode" id="sm_expansion" value="expansion" <?php checked('expansion', $this->options['search_mode']);?>/>
				<label for="sm_expansion"><?php _e('Full-Text Search with Query Expansion', 'wp-fulltext-search') ?> (<a href="http://dev.mysql.com/doc/refman/5.0/en/fulltext-query-expansion.html">#</a>).</label>
				<br/>
			</td>
		</tr>
	</table>
	<p class="submit" style="text-align: center;"><input type="submit" name="drop-index" value="<?php _e('Disable Full-Text Search and Drop the Index &raquo;', 'wp-fulltext-search') ?>" /><br />
	<strong style="color:#f00;"><?php _e('Please, backup your data before you proceed', 'wp-fulltext-search') ?>.</strong></p>
	<?php endif; ?>
	</form>
	</div>
<?php
	}
	function CreateIndex($check_only = true){
		global $wpdb;
		
		$indexes = (array) $wpdb->get_results("SHOW INDEX FROM {$wpdb->prefix}posts", ARRAY_A);
		$columns = array('post_title', 'post_content');
		sort($columns);
		
		$found = false;
		$count = count($indexes);
		for ($i = 0; $i < $count; $i++) {	
			$index = $indexes[$i];
			if ( 0 != strcasecmp('FULLTEXT', $index['Index_type']) ) continue;
			
			$j = 0;	
			$tmp = array();
			while ( ($i + $j) < $count && $index['Key_name'] == $indexes[$i + $j]['Key_name']) {
				$tmp[] = $indexes[$i + $j]['Column_name'];
				$j++;
			}
			sort($tmp);	
		
			if ( 2 == count($tmp) && !count(array_diff($tmp, $columns)) ) {
				$found = true;
				break;
			}
			$i = $i + $j - 1;
		}			

		$this->options['enabled'] = $found;	
		if ( !$check_only && !$found ) {
			return false !== $wpdb->query("ALTER TABLE {$wpdb->prefix}posts ADD FULLTEXT search_posts(post_title, post_content)");
		}
		return $found;
	}	
	function DropIndex() {
		global $wpdb;
		
		// Only delete the added index		
		$wpdb->query("ALTER TABLE {$wpdb->prefix}posts DROP INDEX search_posts");
	}
}

$wpSearch = new WP_FullTextSearch();
add_action('pre_get_posts', array(&$wpSearch, 'GetPostsFilter'));
add_action('admin_menu', array(&$wpSearch, 'AdminMenu'));
?>