<?php
/**
 * upload.php
 *
 * Copyright 2009, Moxiecode Systems AB
 * Released under GPL License.
 *
 * License: http://www.plupload.com/license
 * Contributing: http://www.plupload.com/contributing
 */
if ( defined('ABSPATH') )
    die;
require '../../../wp-load.php';

// Far from perfect, it naively tries to retrieve the list of authors.
function __discover_author($chunk, $key, $authors) {
    if ( preg_match_all('#<dc:creator>(.*?)<#', $chunk, $matches) ) {
        $authors = array_unique( array_merge( $authors, $matches[1] ) );
        set_transient($key, $authors);
    }
}


// TODO Add checks to avoid DoS. Limit the size and the number of chunks.
if ( empty($_REQUEST['name']) || '' == trim($_REQUEST['name']) ) {
    die('{"jsonrpc" : "2.0", "error" : {"code": 101, "message": "Invalid request."}, "id" : "id"}');
}

if ( empty($_POST['_wpnonce']) || !wp_verify_nonce($_POST['_wpnonce'], 'file-upload') )
    die('{"jsonrpc" : "2.0", "error" : {"code": 101, "message": "Invalid nonce."}, "id" : "id"}');

if ( !current_user_can( 'upload_files' ) )
    die('{"jsonrpc" : "2.0", "error" : {"code": 101, "message": "Insufficient permissions."}, "id" : "id"}');

// Get parameters
$chunk = isset($_REQUEST["chunk"]) ? $_REQUEST["chunk"] : 0;
$chunks = isset($_REQUEST["chunks"]) ? $_REQUEST["chunks"] : 0;
$filename = md5(trim($_REQUEST["name"]));

$authors = get_transient('file-' . $filename);
if ( false === $authors ) {
    $authors = array();
    set_transient('file-' . $filename, $authors, 86400);
}

// HTTP headers for no cache etc
header("Expires: Mon, 26 Jul 1997 05:00:00 GMT");
header("Last-Modified: " . gmdate("D, d M Y H:i:s") . " GMT");
header("Cache-Control: no-store, no-cache, must-revalidate");
header("Cache-Control: post-check=0, pre-check=0", false);
header("Pragma: no-cache");


$targetDir = get_temp_dir();

// 5 minutes execution time
@set_time_limit(5 * 60);

// Create target dir
if (!file_exists($targetDir))
    @mkdir($targetDir);

// Look for the content type header
if (isset($_SERVER["HTTP_CONTENT_TYPE"]))
    $contentType = $_SERVER["HTTP_CONTENT_TYPE"];

if (isset($_SERVER["CONTENT_TYPE"]))
    $contentType = $_SERVER["CONTENT_TYPE"];

// TODO Handle errors
// Handle non multipart uploads older WebKit versions didn't support multipart in HTML5
if (strpos($contentType, "multipart") !== false) {
    if (isset($_FILES['file']['tmp_name']) && is_uploaded_file($_FILES['file']['tmp_name'])) {
        // Open temp file
        $out = fopen($targetDir . DIRECTORY_SEPARATOR . $filename, $chunk == 0 ? "wb" : "ab");
        if ($out) {
            // Read binary input stream and append it to temp file
            $in = fopen($_FILES['file']['tmp_name'], "rb");

            if ($in) {
                while ($buff = fread($in, 4096)) {
                    __discover_author($buff, 'file-'.$filename, $authors);
                    fwrite($out, $buff);
                }
            } else {
                die('{"jsonrpc" : "2.0", "error" : {"code": 101, "message": "Failed to open input stream."}, "id" : "id"}');
            }
            fclose($in);
            fclose($out);
            @unlink($_FILES['file']['tmp_name']);
        } else
            die('{"jsonrpc" : "2.0", "error" : {"code": 102, "message": "Failed to open output stream."}, "id" : "id"}');
    } else
        die('{"jsonrpc" : "2.0", "error" : {"code": 103, "message": "Failed to move uploaded file."}, "id" : "id"}');
} else {
    // Open temp file
    $out = fopen($targetDir . DIRECTORY_SEPARATOR . $filename, $chunk == 0 ? "wb" : "ab");
    if ($out) {
        // Read binary input stream and append it to temp file
        $in = fopen("php://input", "rb");

        if ($in) {
            while ($buff = fread($in, 4096)) {
                __discover_author($buff, 'file-'.$filename, $authors);
                fwrite($out, $buff);
            }
        } else
            die('{"jsonrpc" : "2.0", "error" : {"code": 101, "message": "Failed to open input stream."}, "id" : "id"}');

        fclose($in);
        fclose($out);
    } else
        die('{"jsonrpc" : "2.0", "error" : {"code": 102, "message": "Failed to open output stream."}, "id" : "id"}');
}

// Return JSON-RPC response
die('{"jsonrpc" : "2.0", "result" : null, "id" : "id"}');

?>